#include "stdafx.h"
#include "RwExp.h"

#include <rphanim.h>

#include "max.h"
#include "keysample.h"
#include "common.h"
#include "rwcommon.h"

#include "utilities.h"

#include "decomp.h"
#include "ikctrl.h"

#include "characterstudio.h"
#include "selsetskin.h"
#include "matrixmangle.h"



/* Function to convert a linked list of keyframes for bones sorted by time
   into an RpSkinAnim for RpSkin under PowerPipe. */
RpHAnimAnimation *
GenerateHAnimationFromKeyFrameList(AnimKeyFrameListEntry *AnimKeyFrameList)
{
    char debug[512];
    RwInt32 i;
    RpHAnimAnimation *anim = NULL;
    AnimKeyFrameListEntry *temp;
    AnimKeyFrameListEntry *prev;
    RwInt32 numKeyFrames = 0;
    RwInt32 frameIndex = 0;
    RwReal late = -FLT_MAX;
    RwInt32 *framesLeft;
    RwReal *lastFrame;
    RpHAnimStdKeyFrame **lastFramePtr = NULL;
    RpHAnimStdKeyFrame *pFrames = NULL;
    RwInt32 numFrames = 0;
    RwInt32 subHierarchyStart;

    /* count the number of frames we have keys for, also
       calculate a base offset in case we're using sub-hierarchies */
    temp = AnimKeyFrameList->next;
    subHierarchyStart = temp->bone;
    while (temp && temp->time == 0.0f)
    {        
        if (subHierarchyStart > temp->bone)
        {
            subHierarchyStart = temp->bone;
        }
        numFrames++;        
        temp = temp->next;
    }

    /* now offset all the bones by the subHierarchy start offset,
       this will be zero in the case of a non sub-hierarchy export */
    temp = AnimKeyFrameList->next;
    while (temp)
    {        
        temp->bone = temp->bone - subHierarchyStart;
        temp = temp->next;
    }

    framesLeft = (RwInt32 *)RwMalloc(sizeof(RwInt32) * numFrames);
    lastFrame = (RwReal *)RwMalloc(sizeof(RwReal) * numFrames);
    lastFramePtr = (RpHAnimStdKeyFrame **)RwMalloc(sizeof(RpHAnimStdKeyFrame *) * numFrames);
    for (i=0; i<numFrames; i++)
    {
        framesLeft[i] = 0;
        lastFrame[i] = 0;
        lastFramePtr[i] = NULL;
    }
    temp = AnimKeyFrameList->next;
    while (temp)
    {
        if (temp->time > late)
        {
            late = temp->time;
        }
        numKeyFrames++;
        framesLeft[temp->bone]++;
        temp = temp->next;
    }
    anim = RpHAnimAnimationCreate(rpHANIMSTDKEYFRAMETYPEID, numKeyFrames, 0, late);
    pFrames = (RpHAnimStdKeyFrame *)anim->pFrames;

    /* grab a first and second frame for each bone */
    for (i=0; i<numFrames*2; i++)
    {
        prev = AnimKeyFrameList;
        temp = AnimKeyFrameList->next;
        while(temp->bone != (RwUInt32)(i % numFrames))
        {
            prev = temp;
            temp = temp->next;
        }
        sprintf(debug, "bone: %d, time: %f\n", temp->bone, temp->time);
        OutputDebugString(debug);
        pFrames[frameIndex].q = temp->q;
        pFrames[frameIndex].t = temp->t;
        pFrames[frameIndex].time = temp->time;
        pFrames[frameIndex].prevFrame = lastFramePtr[temp->bone];
        lastFrame[temp->bone] = temp->time;
        lastFramePtr[temp->bone] = &pFrames[frameIndex];
        frameIndex++;
        framesLeft[temp->bone]--;
        prev->next = temp->next;
        RwFree(temp);

    }
    
    /* now loop through until the list is empty
       finding which bone ends earliest but has
       frames remaining in the list */
    while(AnimKeyFrameList->next)
    {
        RwReal lastFrameTime = FLT_MAX;
        RwInt32 lastBone = -1;
        /* find the bone with the earliest last frame time */
        for (i=0; i<numFrames; i++)
        {
            if (framesLeft[i] && lastFrame[i] < lastFrameTime)
            {
                lastFrameTime = lastFrame[i];
                lastBone = i;            
            }
        }

        /* find the first frame in the list for this bone,
           the list is time sorted */
        prev = AnimKeyFrameList;
        temp = AnimKeyFrameList->next;
        while((RwInt32)temp->bone != lastBone)
        {
            prev = temp;
            temp = temp->next;
        }
        sprintf(debug, "bone: %d, time: %f\n", temp->bone, temp->time);
        OutputDebugString(debug);
        pFrames[frameIndex].q = temp->q;
        pFrames[frameIndex].t = temp->t;
        pFrames[frameIndex].time = temp->time;
        pFrames[frameIndex].prevFrame = lastFramePtr[temp->bone];
        lastFrame[temp->bone] = temp->time;
        lastFramePtr[temp->bone] = &pFrames[frameIndex];
        frameIndex++;        
        framesLeft[temp->bone]--;
        prev->next = temp->next;
        RwFree(temp);
    }

    RwFree(framesLeft);
    RwFree(lastFrame);
    RwFree(lastFramePtr);
    return anim;

}
